<?php
// ENQUEUE PARENT THEME, CUSTOM CSS & CUSTOM JS //////////////////////////////////////////////
add_action( 'wp_enqueue_scripts', 'bh_theme_scripts' );
function bh_theme_scripts() {
     
	 wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css' );
	 wp_enqueue_style( 'spaltenstyle', get_stylesheet_directory_uri() . '/spaltenstyle.css' );
     wp_enqueue_style( 'masonry', get_stylesheet_directory_uri() . '/masonry.css' );
     wp_enqueue_style( 'meine-schrift', get_stylesheet_directory_uri() . '/meine-schrift.css' );
	 wp_enqueue_script( 'custom-js', get_stylesheet_directory_uri() . '/script.js', array( 'jquery' ));

}
// PARENT THEME ENTFERNEN ///////////////////////////////////////////////////////////////
add_filter('wp_prepare_themes_for_js','kill_themes');
function kill_themes($themes) {
	
	unset($themes['Divi']);
	return $themes;
}

/*==========================================DIVI IMAGE SIZE SETTING=====================================================*/
/**
 * Create a custom settings page for Divi Image Sizes.
 */
function mytheme_add_settings_page() {
    add_options_page(
        'Divi Image Sizes', // Page title
        'Divi Image Sizes', // Menu title
        'manage_options', // Capability
        'divi-image-sizes', // Menu slug
        'mytheme_render_settings_page' // Callback function
    );
}
add_action( 'admin_menu', 'mytheme_add_settings_page' );

/**
 * Render the settings page content with branding and promotional message.
 */
function mytheme_render_settings_page() {
    ?>
<div class="wrap">
    <form method="post" action="options.php">
        <?php
        settings_fields( 'mytheme_settings_group' );
        do_settings_sections( 'divi-image-sizes' );
        submit_button();
        ?>
    </form>
</div>
<?php
}

/**
 * Register settings, sections, and fields.
 */
function mytheme_register_settings() {
    register_setting(
        'mytheme_settings_group', // Option group
        'disable_divi_image_sizes' // Option name
    );

    add_settings_section(
        'mytheme_settings_section', // ID
        __( '<h1 style="font-size:50px;"> Divi Bildgr&ouml;&szlig;en Einstellung</h1>', 'mytheme' ), // Title
        null, // Callback
        'divi-image-sizes' // Page
    );

    add_settings_field(
        'disable_divi_image_sizes', // ID
        __( 'Verschiedene Bildgr&ouml;&szlig;en ausschalten', 'mytheme' ), // Title
        'mytheme_disable_divi_image_sizes_callback', // Callback
        'divi-image-sizes', // Page
        'mytheme_settings_section' // Section
    );
}
add_action( 'admin_init', 'mytheme_register_settings' );

/**
 * Callback function to render the checkbox field.
 */
function mytheme_disable_divi_image_sizes_callback() {
    $option = get_option( 'disable_divi_image_sizes' );
    ?>
<input type="checkbox" name="disable_divi_image_sizes" value="1" <?php checked( 1, $option, true ); ?> />
<label for="disable_divi_image_sizes">
    <?php _e( 'DIVI Bildgr&ouml;&szlig;en abschalten', 'mytheme' ); ?>
</label>
<?php
}

/**
 * Disable Divi image sizes based on the settings page option.
 */
function disable_divi_image_sizes() {
    if ( get_option( 'disable_divi_image_sizes' ) ) {
        // Remove all image sizes registered by Divi
        remove_image_size( 'et-pb-post-main-image' );
        remove_image_size( 'et-pb-portfolio-image' );
        remove_image_size( 'et-pb-portfolio-module-image' );
        remove_image_size( 'et-pb-gallery-module-image' );
        remove_image_size( 'et-pb-fullwidth-image' );
    }
}
add_action( 'after_setup_theme', 'disable_divi_image_sizes' );

/**
 * Disable WordPress intermediate image sizes based on the settings page option.
 */
function remove_default_image_sizes( $sizes ) {
    if ( get_option( 'disable_divi_image_sizes' ) ) {
        return array();
    }
    return $sizes;
}
add_filter( 'intermediate_image_sizes_advanced', 'remove_default_image_sizes' );

/*=======================================DIVI IMAGE SIZE ENDE=========================================*/


/*===================================== SCHALTET BEI WORDPRESS GALERIE AB, DASS BILDER NUR IM QUER- ODER HOCHFORMAT ANGEZEIGT WERDEN=========================*/

function wpc_remove_height_cropping($height) {
	return '9999';
}
function wpc_remove_width_cropping($width) {
	return '9999';
}
 
add_filter( 'et_pb_gallery_image_height', 'wpc_remove_height_cropping' );
add_filter( 'et_pb_gallery_image_width', 'wpc_remove_width_cropping' );

/*===================================== SCHALTET BEI WORDPRESS GALERIE AB, DASS BILDER NUR IM QUER- ODER HOCHFORMAT ANGEZEIGT WERDEN ENDE=========================*/
